//
//  Accessing_the_Music_LibraryViewController.m
//  Accessing the Music Library
//
//  Created by Vandad Nahavandipoor on 16/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

/* 1 */
//#import "Accessing_the_Music_LibraryViewController.h"
//
//@implementation Accessing_the_Music_LibraryViewController
//
//
//- (void) mediaPicker:(MPMediaPickerController *)mediaPicker 
//   didPickMediaItems:(MPMediaItemCollection *)mediaItemCollection{
//  
//  NSLog(@"Informacje z kontrolera wyboru utworu");
//  
//  for (MPMediaItem *thisItem in mediaItemCollection.items){
//    
//    NSURL     *itemURL = 
//    [thisItem valueForProperty:MPMediaItemPropertyAssetURL];
//    
//    NSString  *itemTitle = 
//    [thisItem valueForProperty:MPMediaItemPropertyTitle];
//    
//    NSString  *itemArtist = 
//    [thisItem valueForProperty:MPMediaItemPropertyArtist];
//    
//    MPMediaItemArtwork *itemArtwork = 
//    [thisItem valueForProperty:MPMediaItemPropertyArtwork];
//    
//    NSLog(@"Adres URL utworu = %@", itemURL);
//    NSLog(@"Tytuł utworu = %@", itemTitle);
//    NSLog(@"Wykonawca = %@", itemArtist);
//    NSLog(@"Okładka = %@", itemArtwork);
//  }
//  
//  [mediaPicker dismissModalViewControllerAnimated:YES];
//  
//}
//
//- (void) mediaPickerDidCancel:(MPMediaPickerController *)mediaPicker{
//  /* Użytkownik anulował operację. */
//  NSLog(@"Użytkownik anulował operację w kontrolerze wyboru utworu z biblioteki");
//  [mediaPicker dismissModalViewControllerAnimated:YES];
//}
//
//- (void) displayMediaPicker{
//  
//  MPMediaPickerController *mediaPicker = [[MPMediaPickerController alloc]
//                                          initWithMediaTypes:MPMediaTypeAny];
//  
//  if (mediaPicker != nil){
//    
//    NSLog(@"Udało się utworzyć kontroler wyboru utworu.");
//    mediaPicker.delegate = self;
//    mediaPicker.allowsPickingMultipleItems = NO;
//    
//    [self.navigationController presentModalViewController:mediaPicker
//                                                 animated:YES];
//    
//  } else {
//    NSLog(@"Nie udało się utworzyć kontrolera wyboru utworu.");
//  }
//  
//}
//
//- (void)viewDidLoad {
//  [super viewDidLoad];
//  [self displayMediaPicker];
//}
//
//- (void) viewDidUnload{
//  [super viewDidUnload];
//}
//
//- (BOOL)shouldAutorotateToInterfaceOrientation
//        :(UIInterfaceOrientation)interfaceOrientation{
//  return YES;
//}
//
//@end

/* 2 */
#import "Accessing_the_Music_LibraryViewController.h"

@implementation Accessing_the_Music_LibraryViewController

@synthesize myMusicPlayer;
@synthesize buttonPickAndPlay;
@synthesize buttonStopPlaying;

- (void) musicPlayerStateChanged:(NSNotification *)paramNotification{
  
  NSLog(@"Zmiana stanu odtwarzacza");
  
  /* Najpierw trzeba pobrać stan odtwarzacza. */
  NSNumber *stateAsObject = 
  [paramNotification.userInfo 
   objectForKey:@"MPMusicPlayerControllerPlaybackStateKey"];
  
  NSInteger state = [stateAsObject integerValue];
  
  /* Odpowiednie działanie zostanie podjęte na podstawie stanu odtwarzacza. */
  switch (state){
    case MPMusicPlaybackStateStopped:{
      /* Odtwarzacz zatrzymał odtwarzanie listy utworów. */
      break;
    }
    case MPMusicPlaybackStatePlaying:{
      /* Odtwarzacz jest w trakcie odtwarzania listy utworów.
         Prawdopodobnie możesz zmniejszyć pewne obciążenie aplikacji
         i przydzielić więcej mocy odtwarzaczowi. */
      break;
    }
    case MPMusicPlaybackStatePaused:{
      /* Odtwarzacz wstrzymał odtwarzanie listy utworów. Możesz to
         przedstawić wizualnie poprzez wyświetlenie użytkownikowi pewnej grafiki. */
      break;
    }
    case MPMusicPlaybackStateInterrupted:{
      /* Zakłócenie spowodowało przerwanie odtwarzania listy utworów. */
      break;
    }
    case MPMusicPlaybackStateSeekingForward:{
      /* Użytkownik porusza się do tyłu listy utworów. */
      break;
    }
    case MPMusicPlaybackStateSeekingBackward:{
      /* Użytkownik porusza się do przodu listy utworów. */
      break;
    }
  } /* switch (State){ */
  
}

- (void) nowPlayingItemIsChanged:(NSNotification *)paramNotification{
  
  NSLog(@"Zmianie uległ odtwarzany utwór.");
  
  NSString *persistentID = 
  [paramNotification.userInfo 
   objectForKey:@"MPMusicPlayerControllerNowPlayingItemPersistentIDKey"];
  
  /* Do something with Persistent ID */
  NSLog(@"Persistent ID = %@", persistentID);
  
}

- (void) volumeIsChanged:(NSNotification *)paramNotification{
  NSLog(@"Poziom głośności uległ zmianie.");  
  /* Słownik userInfo tego powiadomienia normalnie jest pusty. */
}


- (void) mediaPicker:(MPMediaPickerController *)mediaPicker 
   didPickMediaItems:(MPMediaItemCollection *)mediaItemCollection{
  
  NSLog(@"Informacje z kontrolera wyboru utworu");
  
  /* Najpierw trzeba usunąć odtwarzacz muzyczny,
   jeśli taki został utworzony już wcześniej. */
  self.myMusicPlayer = nil;
  
  self.myMusicPlayer = [[MPMusicPlayerController alloc] init];
  
  [self.myMusicPlayer beginGeneratingPlaybackNotifications];
  
  /* Powiadomienie o zmianie stanu podczas odtwarzania treści. */
  [[NSNotificationCenter defaultCenter]
   addObserver:self
   selector:@selector(musicPlayerStateChanged:)
   name:MPMusicPlayerControllerPlaybackStateDidChangeNotification
   object:self.myMusicPlayer];
  
  /* Powiadomienie o zmianie odtwarzanego utworu, tzn. o
    przejściu do innego. W omawianej aplikacji użytkownik może
   wybrać tylko jeden plik muzyczny. */
  [[NSNotificationCenter defaultCenter]
   addObserver:self
   selector:@selector(nowPlayingItemIsChanged:)
   name:MPMusicPlayerControllerNowPlayingItemDidChangeNotification
   object:self.myMusicPlayer];
  
  /* Powiadomienie o zmianie poziomu głośności
   w odtwarzaczu muzycznym. */
  [[NSNotificationCenter defaultCenter]
   addObserver:self
   selector:@selector(volumeIsChanged:)
   name:MPMusicPlayerControllerVolumeDidChangeNotification
   object:self.myMusicPlayer];
  
  /* Rozpoczęcie odtwarzania utworów z kolekcji. */
  [self.myMusicPlayer setQueueWithItemCollection:mediaItemCollection];
  [self.myMusicPlayer play];
  
  /* Usunięcie z ekranu kontrolera wyboru utworu z biblioteki. */
  [mediaPicker dismissModalViewControllerAnimated:YES];
  
}

- (void) mediaPickerDidCancel:(MPMediaPickerController *)mediaPicker{
  
  /* Użytkownik anulował operację */
  NSLog(@"Użytkownik anulował operację w kontrolerze wyboru utworu z biblioteki");
  [mediaPicker dismissModalViewControllerAnimated:YES];
  
}

- (void) stopPlayingAudio{
  
  if (self.myMusicPlayer != nil){
    
    [[NSNotificationCenter defaultCenter] 
     removeObserver:self
     name:MPMusicPlayerControllerPlaybackStateDidChangeNotification
     object:self.myMusicPlayer];
    
    [[NSNotificationCenter defaultCenter]
     removeObserver:self
     name:MPMusicPlayerControllerNowPlayingItemDidChangeNotification
     object:self.myMusicPlayer];
    
    [[NSNotificationCenter defaultCenter]
     removeObserver:self
     name:MPMusicPlayerControllerVolumeDidChangeNotification
     object:self.myMusicPlayer];
    
    [self.myMusicPlayer stop];
  }
  
}

- (void) displayMediaPickerAndPlayItem{
  
  MPMediaPickerController *mediaPicker = 
  [[MPMediaPickerController alloc] 
   initWithMediaTypes:MPMediaTypeMusic];
  
  if (mediaPicker != nil){
    
    NSLog(@"Udało się utworzyć kontroler wyboru utworu.");
    mediaPicker.delegate = self;
    mediaPicker.allowsPickingMultipleItems = YES;
    
    [self.navigationController presentModalViewController:mediaPicker
                                                 animated:YES];
    
  } else {
    NSLog(@"Nie udało się utworzyć kontrolera wyboru utworu.");
  }
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  self.view.backgroundColor = [UIColor whiteColor];
  
  self.buttonPickAndPlay = [UIButton buttonWithType:UIButtonTypeRoundedRect];
  self.buttonPickAndPlay.frame = CGRectMake(0.0f, 
                                            0.0f, 
                                            200, 
                                            37.0f);
  self.buttonPickAndPlay.center = CGPointMake(self.view.center.x,
                                              self.view.center.y - 50);
  [self.buttonPickAndPlay setTitle:@"Wybierz i odtwórz"
                          forState:UIControlStateNormal];
  [self.buttonPickAndPlay addTarget:self
                             action:@selector(displayMediaPickerAndPlayItem)
                   forControlEvents:UIControlEventTouchUpInside];
  [self.view addSubview:self.buttonPickAndPlay];
  
  self.buttonStopPlaying = [UIButton buttonWithType:UIButtonTypeRoundedRect];
  self.buttonStopPlaying.frame = CGRectMake(0.0f, 
                                            0.0f, 
                                            200, 
                                            37.0f);
  self.buttonStopPlaying.center = CGPointMake(self.view.center.x,
                                              self.view.center.y + 50);
  [self.buttonStopPlaying setTitle:@"Zatrzymaj odtwarzanie"
                          forState:UIControlStateNormal];
  [self.buttonStopPlaying addTarget:self
                             action:@selector(stopPlayingAudio)
                   forControlEvents:UIControlEventTouchUpInside];
  [self.view addSubview:self.buttonStopPlaying];
  
  [self.navigationController setNavigationBarHidden:YES
                                           animated:NO];
}

- (void) viewDidUnload{
  [super viewDidUnload];
  
  [self stopPlayingAudio];
  self.myMusicPlayer = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
